package ru.yandex.infra.stage;

import java.util.Map;
import java.util.Set;

import ru.yandex.bolts.collection.Try;
import ru.yandex.infra.controller.dto.SchemaMeta;
import ru.yandex.infra.controller.dto.StageMeta;
import ru.yandex.infra.controller.yp.YpObject;
import ru.yandex.yp.client.api.TProjectSpec;
import ru.yandex.yp.client.api.TProjectStatus;
import ru.yandex.yp.client.api.TStageSpec;
import ru.yandex.yp.client.api.TStageStatus;

public interface RootController {

    void beginStatisticsCollection();

    void buildStatistics();

    void updateStatuses();

    void processGcForRemovedStages(Set<String> stageIdsWithDeployEngine, Set<String> allStageIds);

    void sync(Map<String, Try<YpObject<StageMeta, TStageSpec, TStageStatus>>> currentSpecs,
            Map<String, Try<YpObject<SchemaMeta, TProjectSpec, TProjectStatus>>> currentProjects);
}
