package ru.yandex.infra.stage;

import java.util.Map;
import java.util.Objects;

import com.google.common.base.MoreObjects;

import ru.yandex.infra.controller.dto.Acl;
import ru.yandex.infra.stage.deployunit.DeployUnitStats;
import ru.yandex.infra.stage.dto.ClusterAndType;
import ru.yandex.infra.stage.dto.DeployUnitStatus;
import ru.yandex.infra.stage.dto.DynamicResourceStatus;
import ru.yandex.infra.stage.dto.RuntimeDeployControls;
import ru.yandex.infra.stage.dto.StageSpec;
import ru.yandex.infra.stage.dto.StageStatus;
import ru.yandex.infra.stage.yp.DeployObjectId;
import ru.yandex.infra.stage.yp.Retainment;
import ru.yandex.inside.yt.kosher.ytree.YTreeNode;

public interface StageController {
    class Status {
        private final Map<String, DeployUnitStatus> deployUnits;
        private final Map<String, DynamicResourceStatus> dynamicResources;

        public Status(Map<String, DeployUnitStatus> deployUnits,
                      Map<String, DynamicResourceStatus> dynamicResources) {
            this.deployUnits = deployUnits;
            this.dynamicResources = dynamicResources;
        }

        public Map<String, DeployUnitStatus> getDeployUnits() {
            return deployUnits;
        }

        public Map<String, DynamicResourceStatus> getDynamicResources() {
            return dynamicResources;
        }


        public static Status fromStageStatus(StageStatus stageStatus) {
            return new Status(stageStatus.getDeployUnits(), stageStatus.getDynamicResources()
            );
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || getClass() != o.getClass()) {
                return false;
            }
            Status status = (Status) o;
            return Objects.equals(deployUnits, status.deployUnits) &&
                    Objects.equals(dynamicResources, status.dynamicResources);
        }

        @Override
        public int hashCode() {
            return Objects.hash(deployUnits, dynamicResources);
        }

        @Override
        public String toString() {
            return MoreObjects.toStringHelper(this)
                    .add("deployUnits", deployUnits)
                    .add("dynamicResources", dynamicResources)
                    .toString();
        }
    }


    // you get warranty update spec!!
    void sync(String stageFqid,
              StageSpec newSpec,
              RuntimeDeployControls runtimeDeployControls,
              Map<String, YTreeNode> labels,
              long newSpecTimestamp,
              Acl newAcl,
              String projectId);

    void restoreFromStatus(String stageFqid,
                           int stageRevision,
                           Status status,
                           RuntimeDeployControls runtimeDeployControls,
                           Map<String, YTreeNode> labels,
                           String accountId,
                           Acl acl,
                           String projectId,
                           Map<String, String> envVars);

    Status getStatus();

    Retainment shouldRetain(DeployObjectId objectId, ClusterAndType clusterAndType);

    void addStats(DeployUnitStats.Builder builder);

    void shutdown();
}
