package ru.yandex.infra.stage;

import java.util.Optional;

import ru.yandex.bolts.collection.Try;
import ru.yandex.infra.controller.dto.SchemaMeta;
import ru.yandex.infra.controller.dto.StageMeta;
import ru.yandex.infra.controller.yp.YpObject;
import ru.yandex.infra.stage.deployunit.DeployUnitStats;
import ru.yandex.infra.stage.dto.ClusterAndType;
import ru.yandex.infra.stage.yp.DeployObjectId;
import ru.yandex.infra.stage.yp.Retainment;
import ru.yandex.yp.client.api.TProjectSpec;
import ru.yandex.yp.client.api.TProjectStatus;
import ru.yandex.yp.client.api.TStageSpec;
import ru.yandex.yp.client.api.TStageStatus;

public interface ValidationController {
    enum ValidityType {
        VALID,
        INVALID,
        PARSING_FAILED
    }

    void sync(Try<YpObject<StageMeta, TStageSpec, TStageStatus>> specStatusTry,
            Optional<Try<YpObject<SchemaMeta, TProjectSpec, TProjectStatus>>> projectSpecTry);
    ValidityType getValidConditionType();
    Retainment shouldRetain(DeployObjectId objectId, ClusterAndType clusterAndType);
    void addStats(DeployUnitStats.Builder builder);
    void shutdown();
    void updateStatus();
}
