package ru.yandex.infra.stage.cache;

import java.util.Map;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;

public interface Cache<TValue> {

    Map<String, TValue> getAll();
    Optional<TValue> get(String key);

    CompletableFuture<?> put(String key, TValue value);
    CompletableFuture<?> remove(String key);
}
