package ru.yandex.infra.stage.cache;

import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;

import com.google.protobuf.Message;

public class CacheSet {
    private final Map<CachedObjectType<?, ?>, Cache<?>> caches;

    public CacheSet(Function<CachedObjectType<?, ?>, Cache<?>> factory) {
        caches = CachedObjectType.ALL.values().stream()
                .collect(Collectors.toMap(type -> type, factory));
    }

    public <TValue, TProtoValue extends Message> Cache<TValue> get(CachedObjectType<TValue, TProtoValue> cachedObjectType) {
        return (Cache<TValue>) caches.get(cachedObjectType);
    }
}
