package ru.yandex.infra.stage.cache;

import java.util.Map;
import java.util.concurrent.CompletableFuture;

import com.google.protobuf.Message;

public interface CacheStorage<TProtoValue extends Message> {

    CompletableFuture<?> init();

    CompletableFuture<?> flush();

    CompletableFuture<Map<String, TProtoValue>> read();

    CompletableFuture<?> write(Map<String, TProtoValue> values);

    CompletableFuture<?> write(String key, TProtoValue value);

    CompletableFuture<?> remove(String key);
}
