package ru.yandex.infra.stage.cache;

import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.function.Supplier;

import com.google.common.collect.ImmutableMap;
import com.google.protobuf.Message;

import ru.yandex.infra.stage.TDockerImageContents;
import ru.yandex.infra.stage.TSingleResourceState;
import ru.yandex.infra.stage.dto.DockerImageContents;
import ru.yandex.infra.stage.dto.DownloadableResource;
import ru.yandex.infra.stage.podspecs.ResourceWithMeta;
import ru.yandex.infra.stage.protobuf.Converter;
import ru.yandex.yp.client.api.TDownloadableResource;

public class CachedObjectType<TValue, TProtoValue extends Message> {

    private static final List<CachedObjectType<?, ?>> all = new LinkedList<>();

    public static final CachedObjectType<DockerImageContents, TDockerImageContents>
            DOCKER_IMAGE_CONTENTS = new CachedObjectType<>("docker", TDockerImageContents::newBuilder, Converter::fromProto, Converter::toProto);
    public static final CachedObjectType<ResourceWithMeta, TSingleResourceState>
            RESOURCES = new CachedObjectType<>("resources", TSingleResourceState::newBuilder, Converter::fromProto, Converter::toProto);
    public static final CachedObjectType<DownloadableResource, TDownloadableResource>
            SANDBOX_RESOURCES = new CachedObjectType<>("sandbox_resources", TDownloadableResource::newBuilder, Converter::fromProto, Converter::toProto);

    public static final Map<String, CachedObjectType<?,?>> ALL = all.stream()
            .collect(ImmutableMap.toImmutableMap(CachedObjectType::getName, t -> t));

    private final String name;
    private final Function<TValue, TProtoValue> toProto;
    private final Function<TProtoValue, TValue> fromProto;
    private final Supplier<Message.Builder> builderSupplier;

    CachedObjectType(String name,
                     Supplier<Message.Builder> builderSupplier,
                     Function<TProtoValue, TValue> fromProto,
                     Function<TValue, TProtoValue> toProto) {
        this.name = name;
        this.builderSupplier = builderSupplier;
        this.fromProto = fromProto;
        this.toProto = toProto;

        all.add(this);
    }

    public String getName() {
        return name;
    }

    public Supplier<Message.Builder> getBuilderSupplier() {
        return builderSupplier;
    }

    public Function<TValue, TProtoValue> getToProto() {
        return toProto;
    }

    public Function<TProtoValue, TValue> getFromProto() {
        return fromProto;
    }
}
