package ru.yandex.infra.stage.cache;

import java.util.Map;
import java.util.concurrent.CompletableFuture;

import com.google.protobuf.Message;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ReadonlyCacheStorage<TProtoValue extends Message> implements CacheStorage<TProtoValue> {

    private static final Logger LOG = LoggerFactory.getLogger(ReadonlyCacheStorage.class);

    private final CacheStorage<TProtoValue> cacheStorage;

    public ReadonlyCacheStorage(CacheStorage<TProtoValue> cacheStorage) {
        this.cacheStorage = cacheStorage;
    }

    @Override
    public CompletableFuture<?> write(Map<String, TProtoValue> newValues) {
        LOG.info("[readonly mode] Operation skipped: write map with {} items", newValues.size());
        return CompletableFuture.completedFuture(null);
    }

    @Override
    public CompletableFuture<?> init() {
        return cacheStorage.init();
    }

    @Override
    public CompletableFuture<?> flush() {
        LOG.info("[readonly mode] Operation skipped: flush");
        return CompletableFuture.completedFuture(null);
    }

    @Override
    public CompletableFuture<Map<String, TProtoValue>> read() {
        return cacheStorage.read();
    }

    @Override
    public CompletableFuture<?> write(String key, TProtoValue tProtoValue) {
        LOG.info("[readonly mode] Operation skipped: write key {}", key);
        return CompletableFuture.completedFuture(null);
    }

    @Override
    public CompletableFuture<?> remove(String key) {
        LOG.info("[readonly mode] Operation skipped: remove {}", key);
        return CompletableFuture.completedFuture(null);
    }
}
