package ru.yandex.infra.stage.cache;

import java.util.Arrays;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;

public enum StorageType {
    EMPTY("empty"),
    YT_TABLES("yt_tables"),
    LOCAL_FILE_SYSTEM("local_file_system")
    ;

    private final String name;

    StorageType(String name) {
        this.name = name;
    }

    public String getName() {
        return name;
    }

    private static final Map<String, StorageType> allValues = Arrays.stream(StorageType.values())
            .collect(Collectors.toUnmodifiableMap(StorageType::getName, Function.identity()));

    public static StorageType get(String storageType) {
        StorageType type = StorageType.allValues.get(storageType);
        if(type == null) {
            throw new RuntimeException("Unknown storage type from 'config.cache.storage_type': " + storageType);
        }
        return type;
    }
}
