package ru.yandex.infra.stage.config;

import java.util.Map;

import com.google.common.annotations.VisibleForTesting;
import com.typesafe.config.Config;
import com.typesafe.config.ConfigFactory;

import ru.yandex.infra.stage.dto.AllComputeResources;

public final class AllComputeResourcesConfigParser {

    private AllComputeResourcesConfigParser() {
    }

    @VisibleForTesting
    static final String VCPU_GUARANTEE_CONFIG_PATH = "vcpu_guarantee";

    @VisibleForTesting
    static final String VCPU_LIMIT_CONFIG_PATH = "vcpu_limit";

    @VisibleForTesting
    static final String MEMORY_GUARANTEE_CONFIG_PATH = "memory_guarantee";

    @VisibleForTesting
    static final String MEMORY_LIMIT_CONFIG_PATH = "memory_limit";

    @VisibleForTesting
    static final String ANONYMOUS_MEMORY_LIMIT_CONFIG_PATH = "anonymous_memory_limit";

    @VisibleForTesting
    static final String HDD_CAPACITY_CONFIG_PATH = "hdd_capacity";

    @VisibleForTesting
    static final String THREAD_LIMIT_CONFIG_PATH = "thread_limit";

    public static AllComputeResources parseConfig(Config config) {
        var vcpuGuarantee = config.getLong(VCPU_GUARANTEE_CONFIG_PATH);
        var vcpuLimit = config.getLong(VCPU_LIMIT_CONFIG_PATH);
        var memoryGuarantee = MemoryConfigParser.parseMemoryFrom(config, MEMORY_GUARANTEE_CONFIG_PATH);
        var memoryLimit = MemoryConfigParser.parseMemoryFrom(config, MEMORY_LIMIT_CONFIG_PATH);
        var anonymousMemoryLimit = MemoryConfigParser.parseMemoryFrom(config, ANONYMOUS_MEMORY_LIMIT_CONFIG_PATH);
        var hddCapacity = MemoryConfigParser.parseMemoryFrom(config, HDD_CAPACITY_CONFIG_PATH);
        var threadLimit = config.getLong(THREAD_LIMIT_CONFIG_PATH);

        return new AllComputeResources(
                vcpuGuarantee,
                vcpuLimit,
                memoryGuarantee,
                memoryLimit,
                anonymousMemoryLimit,
                hddCapacity,
                threadLimit
        );
    }

    @VisibleForTesting
    public static Config toConfig(AllComputeResources resources) {
        return ConfigFactory.parseMap(Map.of(
                VCPU_GUARANTEE_CONFIG_PATH, resources.getVcpuGuarantee(),
                VCPU_LIMIT_CONFIG_PATH, resources.getVcpuLimit(),
                MEMORY_GUARANTEE_CONFIG_PATH, resources.getMemoryGuarantee(),
                MEMORY_LIMIT_CONFIG_PATH, resources.getMemoryLimit(),
                ANONYMOUS_MEMORY_LIMIT_CONFIG_PATH, resources.getAnonymousMemoryLimit(),
                HDD_CAPACITY_CONFIG_PATH, resources.getDiskCapacity(),
                THREAD_LIMIT_CONFIG_PATH, resources.getThreadLimit()
        ));
    }
}
