package ru.yandex.infra.stage.config;

import java.util.HashMap;
import java.util.Map;
import java.util.function.Function;

import com.google.common.annotations.VisibleForTesting;
import com.typesafe.config.Config;
import one.util.streamex.EntryStream;

import static ru.yandex.infra.controller.util.StringUtils.ID_SEPARATOR;
import static ru.yandex.infra.stage.ConfigUtils.CONFIG_FROM_CONFIG;
import static ru.yandex.infra.stage.ConfigUtils.extractMap;

public final class WhiteListConfigParser {

    private WhiteListConfigParser() {

    }

    @VisibleForTesting
    public static final String WHITE_LIST_CONFIG_PATH = "white_list";

    public static <ValueType> Map<String, ValueType> parseConfig(Config config,
                                                                 Function<Config, ValueType> valueConfigParser) {
        var stageToDeployUnitConfigs = extractMap(
                config,
                CONFIG_FROM_CONFIG
        );

        Map<String, ValueType> deployUnitValues = new HashMap<>();
        EntryStream.of(stageToDeployUnitConfigs)
                .forKeyValue((stageId, stageConfig) -> {
                    var stageDeployUnitLimits = extractMap(
                            stageConfig,
                            CONFIG_FROM_CONFIG,
                            valueConfigParser
                    );

                    EntryStream.of(stageDeployUnitLimits)
                            // TODO made util method 'toFullDeployUnitId'
                            .mapKeys(deployUnitId -> stageId + ID_SEPARATOR + deployUnitId)
                            .forKeyValue(deployUnitValues::put);
                });

        return deployUnitValues;
    }

    public static <ValueType> Map<String, ValueType> parseWhiteListFrom(Config config,
                                                                        Function<Config, ValueType> valueConfigParser) {
        return parseConfig(
                config.getConfig(WHITE_LIST_CONFIG_PATH),
                valueConfigParser
        );
    }
}
