package ru.yandex.infra.stage.deployunit;

import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;

import org.apache.commons.lang3.tuple.Pair;

import ru.yandex.infra.stage.StageContext;
import ru.yandex.inside.yt.kosher.ytree.YTreeNode;

public abstract class DeployController<Spec, Status extends ReadyStatus> {

    protected final Map<String, Pair<Runnable, Boolean>> todoApprove = new HashMap<>();

    protected void doApprove(Set<String> approvedSet) {
        Iterator<Map.Entry<String, Pair<Runnable, Boolean>>> iterator = todoApprove.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry<String, Pair<Runnable, Boolean>> needApproveEntry = iterator.next();
            if (approvedSet.contains(needApproveEntry.getKey()) || !needApproveEntry.getValue().getValue()) {
                needApproveEntry.getValue().getKey().run();
                iterator.remove();
            }
        }
    }

    public abstract boolean isEquals(Map<String, Spec> newSpecs,
                               StageContext stageContext,
                               Map<String, Map<String, YTreeNode>> labels,
                               List<Pair<String, Boolean>> clusterSequence);

    public abstract void sync(Map<String, Spec> newSpecs,
                       StageContext stageContext,
                       Set<String> approvedSet,
                       Map<String, Map<String, YTreeNode>> labels,
                       List<Pair<String, Boolean>> clusterSequence);

    public abstract Map<String, Status> getClusterStatuses();

    public abstract void shutdown();

    public abstract void addStats(DeployUnitStats.Builder builder);

    public abstract DeployControllerType getType();

    enum DeployControllerType {
        PARALLEL,
        SEQUENTIAL
    }

}
