package ru.yandex.infra.stage.deployunit;

import ru.yandex.infra.stage.StageContext;
import ru.yandex.infra.stage.dto.ClusterAndType;
import ru.yandex.infra.stage.dto.DeployUnitSpec;
import ru.yandex.infra.stage.dto.DeployUnitStatus;
import ru.yandex.infra.stage.yp.Retainment;

// Status is passed only via event callbacks, comprehensive status computation is not implemented yet
public interface DeployUnitController {
    void start();
    void updateSpec(DeployUnitSpec spec, StageContext context);
    void restoreFromStatus(DeployUnitStatus status, StageContext context);
    Retainment shouldRetain(ClusterAndType clusterAndType);
    void addStats(DeployUnitStats.Builder builder);
    void shutdown();
}
