package ru.yandex.infra.stage.deployunit;

import com.google.common.base.MoreObjects;
import com.google.common.base.Objects;

import ru.yandex.infra.stage.dto.DeployUnitSpec;

public class DeployUnitDescription {

    private final DeployUnitSpec spec;
    private final String fullId;

    public DeployUnitDescription(String fullId, DeployUnitSpec spec) {
        this.spec = spec;
        this.fullId = fullId;
    }

    public DeployUnitSpec getSpec() {
        return spec;
    }

    public String getFullId() {
        return fullId;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        DeployUnitDescription that = (DeployUnitDescription) o;
        return Objects.equal(spec, that.spec) && Objects.equal(fullId, that.fullId);
    }

    @Override
    public int hashCode() {
        return Objects.hashCode(spec, fullId);
    }

    @Override
    public String toString() {
        return MoreObjects.toStringHelper(this)
                .add("spec", spec)
                .add("fullId", fullId)
                .toString();
    }
}
