package ru.yandex.infra.stage.deployunit;

public class DeployUnitStats {
    public final Integer prerequisitesReady;
    public final Integer prerequisitesUnready;
    public final Integer replicaSetReady;
    public final Integer replicaSetUnready;
    public final Integer endpointSetReady;
    public final Integer endpointSetUnready;
    public final Integer horizontalPodAutoscalerReady;
    public final Integer horizontalPodAutoscalerUnready;
    public final Integer dynamicResourcesReady;
    public final Integer dynamicResourcesUnready;
    public final Integer unitTotal;

    public final static DeployUnitStats EMPTY = new DeployUnitStats(null, null, null, null, null, null, null, null, null, null, null);

    public DeployUnitStats(Integer prerequisitesReady,
                           Integer prerequisitesUnready,
                           Integer replicaSetReady,
                           Integer replicaSetUnready,
                           Integer endpointSetReady,
                           Integer endpointSetUnready,
                           Integer horizontalPodAutoscalerReady,
                           Integer horizontalPodAutoscalerUnready,
                           Integer dynamicResourcesReady,
                           Integer dynamicResourcesUnready,
                           Integer unitTotal) {
        this.prerequisitesReady = prerequisitesReady;
        this.prerequisitesUnready = prerequisitesUnready;
        this.replicaSetReady = replicaSetReady;
        this.replicaSetUnready = replicaSetUnready;
        this.endpointSetReady = endpointSetReady;
        this.endpointSetUnready = endpointSetUnready;
        this.horizontalPodAutoscalerReady = horizontalPodAutoscalerReady;
        this.horizontalPodAutoscalerUnready = horizontalPodAutoscalerUnready;
        this.dynamicResourcesReady = dynamicResourcesReady;
        this.dynamicResourcesUnready = dynamicResourcesUnready;
        this.unitTotal = unitTotal;
    }

    public static class Builder {
        private int prerequisitesReady;
        private int prerequisitesUnready;
        private int replicaSetReady;
        private int replicaSetUnready;
        private int endpointSetReady;
        private int endpointSetUnready;
        private int horizontalPodAutoscalerReady;
        private int horizontalPodAutoscalerUnready;
        public int dynamicResourcesReady;
        public int dynamicResourcesUnready;
        private int unitTotal;

        public void addPrerequisitesReadyDeployUnit() {
            ++prerequisitesReady;
            ++unitTotal;
        }

        public void addPrerequisitesUnreadyDeployUnit() {
            ++prerequisitesUnready;
            ++unitTotal;
        }

        public void addReadyReplicaSet() {
            ++replicaSetReady;
        }

        public void addUnreadyReplicaSet() {
            ++replicaSetUnready;
        }

        public void addReadyEndpointSet() {
            ++endpointSetReady;
        }

        public void addUnreadyEndpointSet() {
            ++endpointSetUnready;
        }

        public void addReadyHorizontalPodAutoscaler() {
            ++horizontalPodAutoscalerReady;
        }

        public void addUnreadyHorizontalPodAutoscaler() {
            ++horizontalPodAutoscalerUnready;
        }

        public void addReadyDynamicResource(int podCount) {
            dynamicResourcesReady += podCount;
        }

        public void addUnreadyDynamicResource(int podCount) {
            dynamicResourcesUnready += podCount;
        }

        public DeployUnitStats build() {
            return new DeployUnitStats(prerequisitesReady, prerequisitesUnready, replicaSetReady, replicaSetUnready,
                    endpointSetReady, endpointSetUnready, horizontalPodAutoscalerReady, horizontalPodAutoscalerUnready,
                    dynamicResourcesReady, dynamicResourcesUnready,
                    unitTotal);
        }
    }
}
