package ru.yandex.infra.stage.deployunit;

import java.util.concurrent.CompletableFuture;

import org.apache.commons.codec.binary.Base64;

public class LogbrokerStaticSecretGetterImpl implements LogbrokerSensitiveInformationGetter {
    public static final String STATIC_SECRET_FOR = "STATIC_SECRET_FOR_";

    @Override
    public CompletableFuture<String> getSensitiveInformation(String fullDeployUnitId) {
        String rawSecret = STATIC_SECRET_FOR + fullDeployUnitId;
        byte[] bytesEncoded = Base64.encodeBase64(rawSecret.getBytes());
        CompletableFuture<String> stringCompletableFuture = new CompletableFuture<>();
        stringCompletableFuture.complete(new String(bytesEncoded));
        return stringCompletableFuture;
    }
}
