package ru.yandex.infra.stage.deployunit;

import ru.yandex.infra.stage.dto.LogbrokerCustomTopicRequest;
import ru.yandex.infra.stage.dto.LogbrokerTopicConfig;
import ru.yandex.infra.stage.dto.LogbrokerTopicDescription;
import ru.yandex.infra.stage.dto.LogbrokerTopicRequest;

public final class LogbrokerTopicConfigResolverImpl implements LogbrokerTopicConfigResolver {

    private final LogbrokerTopicDescription communalTopicDescription;
    private final String communalTopicTvmToken;

    public LogbrokerTopicConfigResolverImpl(LogbrokerTopicDescription communalTopicDescription,
                                            String communalTopicTvmToken) {
        this.communalTopicDescription = communalTopicDescription;
        this.communalTopicTvmToken = communalTopicTvmToken;
    }

    private static LogbrokerTopicRequest getTopicRequest(DeployUnitDescription deployUnitDescription) {
        return deployUnitDescription.getSpec().getLogbrokerConfig().getTopicRequest();
    }

    private LogbrokerTopicConfig createCommunalTopicConfig() {
        return new LogbrokerTopicConfig(communalTopicDescription, communalTopicTvmToken);
    }

    private static LogbrokerTopicConfig createCustomTopicConfig(LogbrokerTopicRequest topicRequest) {
        var customTopicRequest = (LogbrokerCustomTopicRequest) topicRequest;

        return new LogbrokerTopicConfig(
                customTopicRequest.getTopicDescription(),
                customTopicRequest.getSecretSelector()
        );
    }

    @Override
    public LogbrokerTopicConfig get(DeployUnitDescription deployUnitDescription) {
        var topicRequest = getTopicRequest(deployUnitDescription);

        return topicRequest instanceof LogbrokerCustomTopicRequest ?
                createCustomTopicConfig(topicRequest) : createCommunalTopicConfig();
    }

}
