package ru.yandex.infra.stage.deployunit;

import java.util.Map;

import com.google.common.annotations.VisibleForTesting;

import ru.yandex.infra.stage.StageContext;
import ru.yandex.inside.yt.kosher.ytree.YTreeNode;

import static java.util.Collections.emptyMap;

public interface ObjectController<Spec, Status> {
    void sync(Spec spec, StageContext stageContext, Map<String, YTreeNode> labels, Map<String, Long> timestampPrerequisites,
              String cluster);

    //For testing only
    @VisibleForTesting
    default void sync(Spec spec, StageContext stageContext) {
        sync(spec, stageContext, emptyMap(), emptyMap(), null);
    }

    //used only for MultiClusterReplicaSetController
    default void sync(Spec spec, StageContext stageContext, Map<String, YTreeNode> labels) {
        sync(spec, stageContext, labels, emptyMap(), null);
    }

    default void sync(Spec spec, StageContext stageContext, Map<String, YTreeNode> labels, String cluster) {
        sync(spec, stageContext, labels, emptyMap(), cluster);
    }

    Status getStatus();

    void shutdown();

    void addStats(DeployUnitStats.Builder builder);
}
