package ru.yandex.infra.stage.deployunit;

import java.util.Map;
import java.util.Objects;

import com.google.common.base.MoreObjects;
import one.util.streamex.EntryStream;

public class ReadinessStatus implements ReadyStatus {
    private final Readiness readiness;

    public ReadinessStatus(Readiness readiness) {
        this.readiness = readiness;
    }

    public Readiness getReadiness() {
        return readiness;
    }

    public static ReadinessStatus merge(Map<String, ReadinessStatus> perClusterStatuses)  {
        return new ReadinessStatus(Readiness.mergeRelated(EntryStream.of(perClusterStatuses)
                .mapValues(ReadinessStatus::getReadiness)
                .toMap()
        ));
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) return true;
        if (!(o instanceof ReadinessStatus)) return false;
        ReadinessStatus status = (ReadinessStatus) o;
        return Objects.equals(readiness, status.readiness);
    }

    @Override
    public int hashCode() {
        return Objects.hash(readiness);
    }

    @Override
    public String toString() {
        return MoreObjects.toStringHelper(this)
                .add("readiness", readiness)
                .toString();
    }

    @Override
    public boolean isReady() {
        return readiness.isReady();
    }
}
