package ru.yandex.infra.stage.deployunit;

import java.util.List;
import java.util.Map;

import ru.yandex.infra.stage.dto.DeployUnitSpec;
import ru.yandex.yp.client.api.DynamicResource.TDynamicResourceSpec;

public interface SandboxResourcesResolver {

    Map<String, String> get(String fullDeployUnitId);

    void registerResultHandlerAndTryGet(String unitId, SandboxResourcesResolveResultHandler handler,
                                        DeployUnitSpec spec, List<TDynamicResourceSpec> dynamicResourceSpecs);

    void unregisterResultHandler(String unitId);

    Readiness getResolveStatus(String fullDeployUnitId);
}
