package ru.yandex.infra.stage.deployunit;

import java.time.Duration;

import com.google.common.base.MoreObjects;

public class WaitingSettings {
    private final Duration waitForSyncInterval;
    private final Duration recheckSuccessfulInterval;

    public WaitingSettings(Duration waitForSyncInterval, Duration recheckSuccessfulInterval) {
        this.waitForSyncInterval = waitForSyncInterval;
        this.recheckSuccessfulInterval = recheckSuccessfulInterval;
    }

    public Duration getWaitForSyncInterval() {
        return waitForSyncInterval;
    }

    public Duration getRecheckSuccessfulInterval() {
        return recheckSuccessfulInterval;
    }


    @Override
    public String toString() {
        return MoreObjects.toStringHelper(this)
                .add("waitForSyncInterval", waitForSyncInterval)
                .add("recheckSuccessfulInterval", recheckSuccessfulInterval)
                .toString();
    }
}
