package ru.yandex.infra.stage.docker;

import ru.yandex.infra.stage.dto.DockerImageDescription;

public interface DockerImagesResolver {
    void registerResultHandler(String unitId, DockerResolveResultHandler handler);
    void unregisterResultHandler(String unitId);

    void addResolve(DockerImageDescription description, String unitId);
    void removeResolve(DockerImageDescription description, String unitId);
    void forceResolve(DockerImageDescription description);

    DockerResolveStatus getResolveStatus(DockerImageDescription description);
}
