package ru.yandex.infra.stage.docker;

import java.util.Objects;
import java.util.Optional;

import com.google.common.base.MoreObjects;

import ru.yandex.infra.stage.deployunit.Readiness;
import ru.yandex.infra.stage.dto.DockerImageContents;

public class DockerResolveStatus {
    private final Readiness readiness;
    private final Optional<DockerImageContents> result;

    private DockerResolveStatus(Readiness readiness, Optional<DockerImageContents> result) {
        this.readiness = readiness;
        this.result = result;
    }

    public static DockerResolveStatus getFailedStatus(String reason, String message) {
        return new DockerResolveStatus(Readiness.failed(reason, message), Optional.empty());
    }

    public static DockerResolveStatus getInProgressStatus(String reason, String message) {
        return new DockerResolveStatus(Readiness.inProgress(reason, message), Optional.empty());
    }

    public static DockerResolveStatus getReadyStatus(DockerImageContents result) {
        return new DockerResolveStatus(Readiness.ready(), Optional.of(result));
    }

    public static DockerResolveStatus getEmptyStatus() {
        return new DockerResolveStatus(Readiness.inProgress("NOT_REQUIRED_DOCKER_IMAGE"), Optional.empty());
    }

    public Readiness getReadiness() {
        return readiness;
    }

    public Optional<DockerImageContents> getResult() {
        return result;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) return true;
        if (!(o instanceof DockerResolveStatus)) return false;
        DockerResolveStatus status = (DockerResolveStatus) o;
        return Objects.equals(readiness, status.readiness) &&
                Objects.equals(result, status.result);
    }

    @Override
    public int hashCode() {
        return Objects.hash(readiness, result);
    }

    @Override
    public String toString() {
        return MoreObjects.toStringHelper(this)
                .add("readiness", readiness)
                .add("result", result)
                .toString();
    }
}
