package ru.yandex.infra.stage.docker;

import java.util.Collections;
import java.util.Map;
import java.util.Objects;

import com.google.common.base.MoreObjects;

import ru.yandex.infra.stage.dto.DockerImageContents;
import ru.yandex.infra.stage.dto.DockerImageDescription;

public class DockerState {
    public static final DockerState EMPTY = new DockerState(Collections.emptyMap());

    private final Map<DockerImageDescription, DockerImageContents> images;

    public DockerState(Map<DockerImageDescription, DockerImageContents> images) {
        this.images = images;
    }

    public Map<DockerImageDescription, DockerImageContents> getImages() {
        return images;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) return true;
        if (!(o instanceof DockerState)) return false;
        DockerState that = (DockerState) o;
        return Objects.equals(images, that.images);
    }

    @Override
    public int hashCode() {
        return Objects.hash(images);
    }


    @Override
    public String toString() {
        return MoreObjects.toStringHelper(this)
                .add("images", images)
                .toString();
    }
}
