package ru.yandex.infra.stage.dto;

import java.util.Objects;
import java.util.Optional;

import com.google.common.base.MoreObjects;

public class AggregatedCondition {
    private final int podCount;
    private final Optional<Condition> condition;

    public AggregatedCondition(int podCount, Optional<Condition> condition) {
        this.podCount = podCount;
        this.condition = condition;
    }

    public int getPodCount() {
        return podCount;
    }

    public Optional<Condition> getCondition() {
        return condition;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        AggregatedCondition that = (AggregatedCondition) o;
        return podCount == that.podCount &&
                Objects.equals(condition, that.condition);
    }

    @Override
    public int hashCode() {
        return Objects.hash(podCount, condition);
    }

    @Override
    public String toString() {
        return MoreObjects.toStringHelper(this)
                .add("podCount", podCount)
                .add("condition", condition)
                .toString();
    }
}
