package ru.yandex.infra.stage.dto;

import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.OptionalInt;

import com.google.common.base.MoreObjects;

public class BoxJugglerConfig {
    public static final int DEFAULT_PORT = 31579;
    private final List<DownloadableResource> archivedChecks;
    private final OptionalInt port;
    private final Optional<DownloadableResource> jugglerBinary;

    public BoxJugglerConfig(List<DownloadableResource> archivedChecks, OptionalInt port, Optional<DownloadableResource> jugglerBinary) {
        this.archivedChecks = archivedChecks;
        this.port = port;
        this.jugglerBinary = jugglerBinary;
    }

    public List<DownloadableResource> getArchivedChecks() {
        return archivedChecks;
    }

    public OptionalInt getPort() {
        return port;
    }

    public int getPortOrDefault() {
        return port.orElse(DEFAULT_PORT);
    }

    public Optional<DownloadableResource> getJugglerBinary() {
        return jugglerBinary;
    }

    @Override
    public String toString() {
        return MoreObjects.toStringHelper(this)
                .add("archivedChecks", archivedChecks)
                .add("port", port)
                .add("jugglerBinary", jugglerBinary)
                .toString();
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) return true;
        if (!(o instanceof BoxJugglerConfig)) return false;
        BoxJugglerConfig config = (BoxJugglerConfig) o;
        return Objects.equals(port, config.port) &&
                Objects.equals(archivedChecks, config.archivedChecks) &&
                Objects.equals(jugglerBinary, config.jugglerBinary);
    }

    @Override
    public int hashCode() {
        return Objects.hash(archivedChecks, port, jugglerBinary);
    }
}
