package ru.yandex.infra.stage.dto;

import java.util.Objects;
import java.util.Optional;

import ru.yandex.yp.model.YpObjectType;

public class ClusterAndType {
    private static final ClusterAndType MCRS = new ClusterAndType(Optional.empty(), YpObjectType.MULTI_CLUSTER_REPLICA_SET);
    private static final ClusterAndType STAGE = new ClusterAndType(Optional.empty(), YpObjectType.STAGE);

    private final Optional<String> cluster;
    private final YpObjectType type;

    private ClusterAndType(Optional<String> cluster, YpObjectType type) {
        this.cluster = cluster;
        this.type = type;
    }

    public static ClusterAndType mcrs() {
        return MCRS;
    }

    public static ClusterAndType stage() {
        return STAGE;
    }

    public static ClusterAndType perClusterInstance(String cluster, YpObjectType type) {
        return new ClusterAndType(Optional.of(cluster), type);
    }

    // empty optional on multi-cluster
    public Optional<String> getCluster() {
        return cluster;
    }

    public YpObjectType getType() {
        return type;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) return true;
        if (!(o instanceof ClusterAndType)) return false;
        ClusterAndType that = (ClusterAndType) o;
        return Objects.equals(cluster, that.cluster) &&
                type == that.type;
    }

    @Override
    public int hashCode() {
        return Objects.hash(cluster, type);
    }

    @Override
    public String toString() {
        return cluster.map(s -> String.format("%s in %s", type.toString().toLowerCase(), s)).orElse(type.toString().toLowerCase());
    }
}
