package ru.yandex.infra.stage.dto;

import java.time.Clock;
import java.time.Instant;
import java.util.Objects;

import com.google.common.base.MoreObjects;

public class Condition {
    public enum Status {
        UNRECOGNIZED,
        UNKNOWN,
        TRUE,
        FALSE
    }

    private final Status status;
    private final String reason;
    private final String message;
    private final Instant timestamp;

    public Condition(Status status, String reason, String message, Instant timestamp) {
        this.status = status;
        this.reason = reason;
        this.message = message;
        this.timestamp = timestamp;
    }

    public boolean isTrue() {
        return status == Status.TRUE;
    }

    public Status getStatus() {
        return status;
    }

    public String getReason() {
        return reason;
    }

    public String getMessage() {
        return message;
    }

    public Instant getTimestamp() {
        return timestamp;
    }

    public static Condition now(Clock clock, boolean value) {
        Status status = value ? Status.TRUE : Status.FALSE;
        return new Condition(status, "", "", clock.instant());
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) return true;
        if (!(o instanceof Condition)) return false;
        Condition condition = (Condition) o;
        return status == condition.status &&
                Objects.equals(reason, condition.reason) &&
                Objects.equals(message, condition.message);
    }

    @Override
    public int hashCode() {
        return Objects.hash(status, reason, message, timestamp);
    }

    @Override
    public String toString() {
        return MoreObjects.toStringHelper(this)
                .add("status", status)
                .add("reason", reason)
                .add("message", message)
                .add("timestamp", timestamp)
                .toString();
    }
}
