package ru.yandex.infra.stage.dto;

import java.util.Objects;
import java.util.Optional;

import com.google.common.base.MoreObjects;

public class CoredumpOutputPolicy {
    private final Optional<String> outputPath;
    private final Optional<String> outputVolumeId;

    public static CoredumpOutputPolicy outputPath(String outputPath) {
        return new CoredumpOutputPolicy(Optional.of(outputPath), Optional.empty());
    }

    public static CoredumpOutputPolicy outputVolumeId(String outputVolumeId) {
        return new CoredumpOutputPolicy(Optional.empty(), Optional.of(outputVolumeId));
    }

    public String getValue() { return outputPath.orElseGet(outputVolumeId::get); }

    public boolean isOutputPath() { return outputPath.isPresent(); }

    public boolean isOutputVolumeId() { return outputVolumeId.isPresent(); }

    private CoredumpOutputPolicy(Optional<String> outputPath, Optional<String> outputVolumeId) {
        this.outputPath = outputPath;
        this.outputVolumeId = outputVolumeId;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        CoredumpOutputPolicy that = (CoredumpOutputPolicy) o;
        return Objects.equals(outputPath, that.outputPath) && Objects.equals(outputVolumeId, that.outputVolumeId);
    }

    @Override
    public int hashCode() {
        return Objects.hash(outputPath, outputVolumeId);
    }

    @Override
    public String toString() {
        return MoreObjects.toStringHelper(this)
                .add("outputPath", outputPath)
                .add("outputVolumeId", outputVolumeId)
                .toString();
    }
}
