package ru.yandex.infra.stage.dto;

import java.util.Objects;

import com.google.common.base.MoreObjects;

public class DeployProgress {
    public static final DeployProgress EMPTY = new DeployProgress(0, 0, 0);
    private final int podsReady;
    private final int podsInProgress;
    private final int podsTotal;

    public DeployProgress(int podsReady, int podsInProgress, int podsTotal) {
        this.podsTotal = podsTotal;
        this.podsReady = podsReady;
        this.podsInProgress = podsInProgress;
    }

    public int getPodsTotal() {
        return podsTotal;
    }

    public int getPodsReady() {
        return podsReady;
    }

    public int getPodsInProgress() {
        return podsInProgress;
    }

    public static DeployProgress sum(DeployProgress first, DeployProgress second) {
        return new DeployProgress(first.podsReady + second.podsReady, first.podsInProgress + second.podsInProgress,
                first.podsTotal + second.podsTotal);
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) return true;
        if (!(o instanceof DeployProgress)) return false;
        DeployProgress that = (DeployProgress) o;
        return podsTotal == that.podsTotal &&
                podsReady == that.podsReady &&
                podsInProgress == that.podsInProgress;
    }

    @Override
    public int hashCode() {
        return Objects.hash(podsTotal, podsReady, podsInProgress);
    }


    @Override
    public String toString() {
        return MoreObjects.toStringHelper(this)
                .add("podsReady", podsReady)
                .add("podsInProgress", podsInProgress)
                .add("podsTotal", podsTotal)
                .toString();
    }
}
