package ru.yandex.infra.stage.dto;


import java.util.Optional;

import com.google.common.base.Objects;


public class DeployReadyCriterion {

    private final Optional<String> type;
    private final Optional<Integer> minReadyPodsPercent;
    private final Optional<Integer> maxNotReadyPods;


    public DeployReadyCriterion(Optional<String> type, Optional<Integer> minReadyPodsPercent, Optional<Integer> maxNotReadyPods) {
        this.type = type;
        this.minReadyPodsPercent = minReadyPodsPercent;
        this.maxNotReadyPods = maxNotReadyPods;
    }

    public Optional<String> getType() {
        return type;
    }

    public Optional<Integer> getMinReadyPodsPercent() {
        return minReadyPodsPercent;
    }

    public Optional<Integer> getMaxNotReadyPods() {
        return maxNotReadyPods;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        DeployReadyCriterion that = (DeployReadyCriterion) o;
        return Objects.equal(type, that.type) && Objects.equal(minReadyPodsPercent, that.minReadyPodsPercent) && Objects.equal(maxNotReadyPods, that.maxNotReadyPods);
    }

    @Override
    public int hashCode() {
        return Objects.hashCode(type, minReadyPodsPercent, maxNotReadyPods);
    }

    @Override
    public String toString() {
        return "DeployReadyCriterion{" +
                "type=" + type +
                ", minReadyPodsPercent=" + minReadyPodsPercent +
                ", maxNotReadyPods=" + maxNotReadyPods +
                '}';
    }
}
