package ru.yandex.infra.stage.dto;

import java.util.Objects;

import com.google.common.base.MoreObjects;

public class DeploySpeed {
    // Number of pods to update at a time.
    private final int updatePortion;
    // Min delay in seconds between updates.
    private final int minDelaySeconds;

    public DeploySpeed(int updatePortion, int minDelaySeconds) {
        this.updatePortion = updatePortion;
        this.minDelaySeconds = minDelaySeconds;
    }

    public int getUpdatePortion() {
        return updatePortion;
    }

    public int getMinDelaySeconds() {
        return minDelaySeconds;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) return true;
        if (!(o instanceof DeploySpeed)) return false;
        DeploySpeed that = (DeploySpeed) o;
        return updatePortion == that.updatePortion &&
                minDelaySeconds == that.minDelaySeconds;
    }

    @Override
    public int hashCode() {
        return Objects.hash(updatePortion, minDelaySeconds);
    }

    @Override
    public String toString() {
        return MoreObjects.toStringHelper(this)
                .add("updatePortion", updatePortion)
                .add("minDelaySeconds", minDelaySeconds)
                .toString();
    }
}
