package ru.yandex.infra.stage.dto;

import java.util.Map;
import java.util.Objects;

import com.google.common.base.MoreObjects;

public class DeployUnitOverrides {
    private final Map<String, PerClusterOverrides> perClusterOverrides;
    private final int revisionToOverride;

    public DeployUnitOverrides(Map<String, PerClusterOverrides> perClusterOverrides, int revisionToOverride) {
        this.perClusterOverrides = perClusterOverrides;
        this.revisionToOverride = revisionToOverride;
    }

    public Map<String, PerClusterOverrides> getPerClusterOverrides() {
        return perClusterOverrides;
    }

    public int getRevisionToOverride() {
        return revisionToOverride;
    }

    public static class PerClusterOverrides {
        private final int maxUnavailable;

        public PerClusterOverrides(int maxUnavailable) {
            this.maxUnavailable = maxUnavailable;
        }

        public int getMaxUnavailable() {
            return maxUnavailable;
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) return true;
            if (!(o instanceof PerClusterOverrides)) return false;
            PerClusterOverrides perClusterOverrides = (PerClusterOverrides) o;
            return Objects.equals(maxUnavailable, perClusterOverrides.maxUnavailable);
        }

        @Override
        public int hashCode() {
            return Objects.hash(maxUnavailable);
        }

        @Override
        public String toString() {
            return MoreObjects.toStringHelper(this)
                    .add("maxUnavailable", maxUnavailable)
                    .toString();
        }
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) return true;
        if (!(o instanceof DeployUnitOverrides)) return false;
        DeployUnitOverrides deployUnitOverrides = (DeployUnitOverrides) o;
        return Objects.equals(perClusterOverrides, deployUnitOverrides.perClusterOverrides) &&
                Objects.equals(revisionToOverride, deployUnitOverrides.revisionToOverride);
    }

    @Override
    public int hashCode() {
        return Objects.hash(perClusterOverrides, revisionToOverride);
    }

    @Override
    public String toString() {
        return MoreObjects.toStringHelper(this)
                .add("perClusterOverrides", perClusterOverrides)
                .add("revisionToOverride", revisionToOverride)
                .toString();
    }
}
