package ru.yandex.infra.stage.dto;

import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

import com.google.common.base.MoreObjects;

import ru.yandex.yp.client.api.DataModel.TEndpointSetSpec;
import ru.yandex.yp.client.api.TDeployUnitSpec;

public class DeployUnitSpec {
    private final int revision;
    private final int patchersRevision;
    private final NetworkDefaults networkDefaults;
    private final Optional<TvmConfig> tvmConfig;
    private final DeployUnitSpecDetails details;
    private final Map<String, DockerImageDescription> imagesForBoxes;
    private final Map<String, TEndpointSetSpec> endpointSets;
    private final Map<String, BoxJugglerConfig> boxJugglerConfigs;
    private final Map<String, LogrotateConfig> logrotateConfig;
    private final LogbrokerConfig logbrokerConfig;
    private final Optional<SecuritySettings> securitySettings;
    private final boolean soxService;
    private final boolean collectPortometricsFromSidecars;
    private final Map<String, CoredumpConfig> coredumpConfig;
    private final Optional<DeploySettings> deploySettings;

    private final Optional<SandboxResourceInfo> tvmToolResourceInfo;
    private final Optional<SandboxResourceInfo> podAgentResourceInfo;
    private final Optional<SandboxResourceInfo> podAgentLayerResourceInfo;
    private final Optional<SandboxResourceInfo> logbrokerToolsResourceInfo;
    private final Optional<SandboxResourceInfo> druLayerResourceInfo;
    private final Optional<SandboxResourceInfo> coredumpToolResourceInfo;
    private final Optional<SandboxResourceInfo> gdbLayerResourceInfo;

    public DeployUnitSpec(int revision,
                          int patchersRevision,
                          NetworkDefaults networkDefaults,
                          Optional<TvmConfig> tvmConfig,
                          DeployUnitSpecDetails details,
                          Map<String, DockerImageDescription> imagesForBoxes,
                          Map<String, TEndpointSetSpec> endpointSets,
                          Map<String, BoxJugglerConfig> boxJugglerConfigs,
                          Map<String, LogrotateConfig> logrotateConfig,
                          LogbrokerConfig logbrokerConfig,
                          Optional<SecuritySettings> securitySettings,
                          boolean soxService,
                          boolean collectPortometricsFromSidecars,
                          Map<String, CoredumpConfig> coredumpConfig,
                          Optional<SandboxResourceInfo> tvmToolResourceInfo,
                          Optional<SandboxResourceInfo> podAgentResourceInfo,
                          Optional<SandboxResourceInfo> podAgentLayerResourceInfo,
                          Optional<SandboxResourceInfo> logbrokerToolsResourceInfo,
                          Optional<SandboxResourceInfo> druLayerResourceInfo,
                          Optional<SandboxResourceInfo> coredumpToolResourceInfo,
                          Optional<SandboxResourceInfo> gdbLayerResourceInfo,
                          Optional<DeploySettings> deploySettings) {
        this.revision = revision;
        this.patchersRevision = patchersRevision;
        this.networkDefaults = networkDefaults;
        this.tvmConfig = tvmConfig;
        this.details = details;
        this.imagesForBoxes = imagesForBoxes;
        this.endpointSets = endpointSets;
        this.boxJugglerConfigs = boxJugglerConfigs;
        this.logrotateConfig = logrotateConfig;
        this.logbrokerConfig = logbrokerConfig;
        this.securitySettings = securitySettings;
        this.soxService = soxService;
        this.collectPortometricsFromSidecars = collectPortometricsFromSidecars;
        this.coredumpConfig = coredumpConfig;
        this.tvmToolResourceInfo = tvmToolResourceInfo;
        this.podAgentResourceInfo = podAgentResourceInfo;
        this.podAgentLayerResourceInfo = podAgentLayerResourceInfo;
        this.logbrokerToolsResourceInfo = logbrokerToolsResourceInfo;
        this.druLayerResourceInfo = druLayerResourceInfo;
        this.coredumpToolResourceInfo = coredumpToolResourceInfo;
        this.gdbLayerResourceInfo = gdbLayerResourceInfo;
        this.deploySettings = deploySettings;
    }

    public DeployUnitSpec withRevision(int revision) {
        return toBuilder().withRevision(revision).build();
    }

    public DeployUnitSpec withNetworkDefaults(NetworkDefaults networkDefaults) {
        return toBuilder().withNetworkDefaults(networkDefaults).build();
    }

    public DeployUnitSpec withTvmConfig(TvmConfig tvmConfig) {
        return toBuilder().withTvmConfig(tvmConfig).build();
    }

    public DeployUnitSpec withJugglerConfig(Map<String, BoxJugglerConfig> boxJugglerConfigs) {
        return toBuilder().withBoxJugglerConfigs(boxJugglerConfigs).build();
    }

    public DeployUnitSpec withImagesForBoxes(Map<String, DockerImageDescription> imagesForBoxes) {
        return toBuilder().withImagesForBoxes(imagesForBoxes).build();
    }

    public DeployUnitSpec withLogbrokerConfig(LogbrokerConfig logbrokerConfig) {
        return toBuilder().withLogbrokerConfig(logbrokerConfig).build();
    }

    public DeployUnitSpec withSecuritySettings(SecuritySettings securitySettings) {
        return toBuilder().withSecuritySettings(securitySettings).build();
    }

    public DeployUnitSpec withCoredumpConfig(Map<String, CoredumpConfig> coredumpConfig) {
        return toBuilder().withCoredumpConfig(coredumpConfig).build();
    }

    public DeployUnitSpec withTvmToolResourceInfo(SandboxResourceInfo tvmToolResourceInfo) {
        return toBuilder().withTvmToolResourceInfo(tvmToolResourceInfo).build();
    }

    public DeployUnitSpec withLogbrokerToolsResourceInfo(SandboxResourceInfo logbrokerToolsResourceInfo) {
        return toBuilder().withLogbrokerToolsResourceInfo(logbrokerToolsResourceInfo).build();
    }

    public DeployUnitSpec withDruLayerResourceInfo(SandboxResourceInfo druLayerResourceInfo) {
        return toBuilder().withDruLayerResourceInfo(druLayerResourceInfo).build();
    }

    public DeployUnitSpec withCoredumpToolResourceInfo(SandboxResourceInfo coredumpToolResourceInfo) {
        return toBuilder().withCoredumpToolResourceInfo(coredumpToolResourceInfo).build();
    }

    public DeployUnitSpec witGdbLayerResourceInfo(SandboxResourceInfo gdbLayerResourceInfo) {
        return toBuilder().withGdbLayerResourceInfo(gdbLayerResourceInfo).build();
    }

    public DeployUnitSpec withDeploySettings(DeploySettings deploySettings) {
        return toBuilder().withDeploySettings(deploySettings).build();
    }

    public DeployUnitSpec withoutDeploySettings() {
        return toBuilder().withoutDeploySettings().build();
    }

    public DeployUnitSpec withDetails(DeployUnitSpecDetails details) {
        return toBuilder().withDetails(details).build();
    }

    public DeployUnitSpec withPatchersRevision(int patchersRevision) {
        return toBuilder().withPatchersRevision(patchersRevision).build();
    }

    public DeployUnitSpec withSoxService(boolean soxService) {
        return toBuilder().withSoxService(soxService).build();
    }

    public DeployUnitSpec withPortoWorkloadMetrics(boolean enableSidecarPortometrics) {
        return toBuilder().withPortoWorkloadMetrics(enableSidecarPortometrics).build();
    }

    public DeployUnitSpec withPodAgentResourceInfo(SandboxResourceInfo podAgentResourceInfo) {
        return toBuilder().withPodAgentResourceInfo(podAgentResourceInfo).build();
    }

    public Map<String, LogrotateConfig> getLogrotateConfig() {
        return logrotateConfig;
    }

    public NetworkDefaults getNetworkDefaults() {
        return networkDefaults;
    }

    public Optional<TvmConfig> getTvmConfig() {
        return tvmConfig;
    }

    public DeployUnitSpecDetails getDetails() {
        return details;
    }

    public Optional<DeploySettings> getDeploySettings() {
        return deploySettings;
    }

    public Map<String, DockerImageDescription> getImagesForBoxes() {
        return imagesForBoxes;
    }

    public Map<String, BoxJugglerConfig> getBoxJugglerConfigs() {
        return boxJugglerConfigs;
    }

    public Map<String, TEndpointSetSpec> getEndpointSets() {
        return endpointSets;
    }

    public LogbrokerConfig getLogbrokerConfig() {
        return logbrokerConfig;
    }

    public Optional<SecuritySettings> getSecuritySettings() { return securitySettings; }

    public int getRevision() {
        return revision;
    }

    public boolean isSoxService() {
        return soxService;
    }

    public boolean isCollectPortometricsFromSidecars() {
        return collectPortometricsFromSidecars;
    }

    public Map<String, CoredumpConfig> getCoredumpConfig() {
        return coredumpConfig;
    }

    public Optional<SandboxResourceInfo> getTvmToolResourceInfo() {
        return tvmToolResourceInfo;
    }

    public Optional<SandboxResourceInfo> getPodAgentResourceInfo() {
        return podAgentResourceInfo;
    }

    public Optional<SandboxResourceInfo> getPodAgentLayerResourceInfo() {
        return podAgentLayerResourceInfo;
    }

    public Optional<SandboxResourceInfo> getLogbrokerToolsResourceInfo() {
        return logbrokerToolsResourceInfo;
    }

    public Optional<SandboxResourceInfo> getDruLayerResourceInfo() {
        return druLayerResourceInfo;
    }

    public Optional<SandboxResourceInfo> getCoredumpToolResourceInfo() {
        return coredumpToolResourceInfo;
    }

    public Optional<SandboxResourceInfo> getGdbLayerResourceInfo() {
        return gdbLayerResourceInfo;
    }

    public int getPatchersRevision() {
        return patchersRevision;
    }

    public static class DeploySettings {

        private final List<ClusterSettings> settings;
        // FIXME is it correct that deploy strategy doesn't used in equals/hashcode/toString?
        private final TDeployUnitSpec.TDeploySettings.EDeployStrategy deployStrategy;

        public DeploySettings(List<ClusterSettings> settings,
                              TDeployUnitSpec.TDeploySettings.EDeployStrategy deployStrategy) {
            this.settings = settings;
            this.deployStrategy = deployStrategy;
        }

        public List<ClusterSettings> getClustersSettings() {
            return settings;
        }

        public TDeployUnitSpec.TDeploySettings.EDeployStrategy getDeployStrategy() {
            return deployStrategy;
        }

        public static class ClusterSettings {
            private final String name;

            private final boolean needApprove;

            public ClusterSettings(String name, boolean needApprove) {
                this.name = name;
                this.needApprove = needApprove;
            }

            public String getName() {
                return name;
            }

            public boolean isNeedApprove() {
                return needApprove;
            }

            @Override
            public boolean equals(Object o) {
                if (this == o) {
                    return true;
                }
                if (o == null || getClass() != o.getClass()) {
                    return false;
                }
                ClusterSettings that = (ClusterSettings) o;
                return needApprove == that.needApprove &&
                        Objects.equals(name, that.name);
            }

            @Override
            public int hashCode() {
                return Objects.hash(name, needApprove);
            }

            @Override
            public String toString() {
                return "ClusterSettings{" +
                        "name='" + name + '\'' +
                        ", needApprove=" + needApprove +
                        '}';
            }


        }

        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || getClass() != o.getClass()) {
                return false;
            }
            DeploySettings that = (DeploySettings) o;
            return Objects.equals(settings, that.settings);
        }

        @Override
        public int hashCode() {
            return Objects.hash(settings);
        }

        @Override
        public String toString() {
            return "DeploySettings{" +
                    "settings=" + settings +
                    '}';
        }

    }

    @Override
    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        DeployUnitSpec that = (DeployUnitSpec) o;
        return revision == that.revision &&
                patchersRevision == that.patchersRevision &&
                soxService == that.soxService &&
                collectPortometricsFromSidecars == that.collectPortometricsFromSidecars &&
                Objects.equals(networkDefaults, that.networkDefaults) &&
                Objects.equals(deploySettings, that.deploySettings) &&
                Objects.equals(tvmConfig, that.tvmConfig) &&
                Objects.equals(details, that.details) &&
                Objects.equals(imagesForBoxes, that.imagesForBoxes) &&
                Objects.equals(endpointSets, that.endpointSets) &&
                Objects.equals(boxJugglerConfigs, that.boxJugglerConfigs) &&
                Objects.equals(logrotateConfig, that.logrotateConfig) &&
                Objects.equals(logbrokerConfig, that.logbrokerConfig) &&
                Objects.equals(securitySettings, that.securitySettings) &&
                Objects.equals(coredumpConfig, that.coredumpConfig) &&
                Objects.equals(tvmToolResourceInfo, that.tvmToolResourceInfo) &&
                Objects.equals(podAgentResourceInfo, that.podAgentResourceInfo) &&
                Objects.equals(podAgentLayerResourceInfo, that.podAgentLayerResourceInfo) &&
                Objects.equals(logbrokerToolsResourceInfo, that.logbrokerToolsResourceInfo) &&
                Objects.equals(coredumpToolResourceInfo, that.coredumpToolResourceInfo) &&
                Objects.equals(gdbLayerResourceInfo, that.gdbLayerResourceInfo) &&
                Objects.equals(druLayerResourceInfo, that.druLayerResourceInfo);
    }

    @Override
    public int hashCode() {
        return Objects.hash(
                revision,
                patchersRevision,
                networkDefaults,
                deploySettings,
                tvmConfig,
                details,
                imagesForBoxes,
                endpointSets,
                boxJugglerConfigs,
                logrotateConfig,
                logbrokerConfig,
                securitySettings,
                soxService,
                collectPortometricsFromSidecars,
                coredumpConfig,
                tvmToolResourceInfo,
                podAgentResourceInfo,
                podAgentLayerResourceInfo,
                logbrokerToolsResourceInfo,
                druLayerResourceInfo,
                coredumpToolResourceInfo,
                gdbLayerResourceInfo
        );
    }

    @Override
    public String toString() {
        return MoreObjects.toStringHelper(this)
                .add("revision", revision)
                .add("patchersRevision", patchersRevision)
                .add("networkDefaults", networkDefaults)
                .add("tvmConfig", tvmConfig)
                .add("details", details)
                .add("imagesForBoxes", imagesForBoxes)
                .add("endpointSets", endpointSets)
                .add("boxJugglerConfigs", boxJugglerConfigs)
                .add("logrotateConfig", logrotateConfig)
                .add("logbrokerConfig", logbrokerConfig)
                .add("securitySettings", securitySettings)
                .add("soxService", soxService)
                .add("collectPortometricsFromSidecars", collectPortometricsFromSidecars)
                .add("coredumpConfig", coredumpConfig)
                .add("deploySettings", deploySettings)
                .add("tvmToolResourceInfo", tvmToolResourceInfo)
                .add("podAgentResourceInfo", podAgentResourceInfo)
                .add("podAgentLayerResourceInfo", podAgentLayerResourceInfo)
                .add("logbrokerToolsResourceInfo", logbrokerToolsResourceInfo)
                .add("druLayerResourceInfo", druLayerResourceInfo)
                .add("coredumpToolResourceInfo", coredumpToolResourceInfo)
                .add("gdbLayerResourceInfo", gdbLayerResourceInfo)
                .toString();
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    public static class Builder {

        private int revision;
        private int patchersRevision;
        private NetworkDefaults networkDefaults;
        private Optional<TvmConfig> tvmConfig;
        private DeployUnitSpecDetails details;
        private Map<String, DockerImageDescription> imagesForBoxes;
        private Map<String, TEndpointSetSpec> endpointSets;
        private Map<String, BoxJugglerConfig> boxJugglerConfigs;
        private Map<String, LogrotateConfig> logrotateConfig;
        private LogbrokerConfig logbrokerConfig;
        private Optional<SecuritySettings> securitySettings;
        private boolean soxService;
        private boolean collectPortometricsFromSidecars;
        private Map<String, CoredumpConfig> coredumpConfig;
        private Optional<DeploySettings> deploySettings;

        private Optional<SandboxResourceInfo> tvmToolResourceInfo;
        private Optional<SandboxResourceInfo> podAgentResourceInfo;
        private final Optional<SandboxResourceInfo> podAgentLayerResourceInfo;
        private Optional<SandboxResourceInfo> logbrokerToolsResourceInfo;
        private Optional<SandboxResourceInfo> druLayerResourceInfo;
        private Optional<SandboxResourceInfo> coredumpToolResourceInfo;
        private Optional<SandboxResourceInfo> gdbLayerResourceInfo;

        Builder(DeployUnitSpec deployUnitSpec) {
            this.revision = deployUnitSpec.revision;
            this.patchersRevision = deployUnitSpec.patchersRevision;
            this.networkDefaults = deployUnitSpec.networkDefaults;
            this.tvmConfig = deployUnitSpec.tvmConfig;
            this.details = deployUnitSpec.details;
            this.imagesForBoxes = deployUnitSpec.imagesForBoxes;
            this.endpointSets = deployUnitSpec.endpointSets;
            this.boxJugglerConfigs = deployUnitSpec.boxJugglerConfigs;
            this.logrotateConfig = deployUnitSpec.logrotateConfig;
            this.logbrokerConfig = deployUnitSpec.logbrokerConfig;
            this.securitySettings = deployUnitSpec.securitySettings;
            this.soxService = deployUnitSpec.soxService;
            this.collectPortometricsFromSidecars = deployUnitSpec.collectPortometricsFromSidecars;
            this.coredumpConfig = deployUnitSpec.coredumpConfig;
            this.tvmToolResourceInfo = deployUnitSpec.tvmToolResourceInfo;
            this.podAgentResourceInfo = deployUnitSpec.podAgentResourceInfo;
            this.podAgentLayerResourceInfo = deployUnitSpec.podAgentLayerResourceInfo;
            this.logbrokerToolsResourceInfo = deployUnitSpec.logbrokerToolsResourceInfo;
            this.druLayerResourceInfo = deployUnitSpec.druLayerResourceInfo;
            this.coredumpToolResourceInfo = deployUnitSpec.coredumpToolResourceInfo;
            this.gdbLayerResourceInfo = deployUnitSpec.gdbLayerResourceInfo;
            this.deploySettings = deployUnitSpec.deploySettings;
        }

        public DeployUnitSpec build() {
            return new DeployUnitSpec(
                    revision,
                    patchersRevision,
                    networkDefaults,
                    tvmConfig,
                    details,
                    imagesForBoxes,
                    endpointSets,
                    boxJugglerConfigs,
                    logrotateConfig,
                    logbrokerConfig,
                    securitySettings,
                    soxService,
                    collectPortometricsFromSidecars,
                    coredumpConfig,
                    tvmToolResourceInfo,
                    podAgentResourceInfo,
                    podAgentLayerResourceInfo,
                    logbrokerToolsResourceInfo,
                    druLayerResourceInfo,
                    coredumpToolResourceInfo,
                    gdbLayerResourceInfo,
                    deploySettings
            );
        }

        public Builder withRevision(int revision) {
            this.revision = revision;
            return this;
        }

        public Builder withImagesForBoxes(Map<String, DockerImageDescription> imagesForBoxes) {
            this.imagesForBoxes = imagesForBoxes;
            return this;
        }

        public Builder withNetworkDefaults(NetworkDefaults networkDefaults) {
            this.networkDefaults = networkDefaults;
            return this;
        }

        public Builder withoutTvmConfig() {
            return withTvmConfig(Optional.empty());
        }

        Builder withTvmConfig(TvmConfig tvmConfig) {
            return withTvmConfig(Optional.ofNullable(tvmConfig));
        }

        private Builder withTvmConfig(Optional<TvmConfig> tvmConfig) {
            this.tvmConfig = tvmConfig;
            return this;
        }

        public Builder withBoxJugglerConfigs(Map<String, BoxJugglerConfig> boxJugglerConfigs) {
            this.boxJugglerConfigs = boxJugglerConfigs;
            return this;
        }

        public Builder withLogbrokerConfig(LogbrokerConfig logbrokerConfig) {
            this.logbrokerConfig = logbrokerConfig;
            return this;
        }

        public Builder withSecuritySettings(SecuritySettings securitySettings) {
            this.securitySettings = Optional.ofNullable(securitySettings);
            return this;
        }

        public Builder withCoredumpConfig(Map<String, CoredumpConfig> coredumpConfig) {
            this.coredumpConfig = coredumpConfig;
            return this;
        }

        Builder withTvmToolResourceInfo(SandboxResourceInfo tvmToolResourceInfo) {
            this.tvmToolResourceInfo = Optional.ofNullable(tvmToolResourceInfo);
            return this;
        }

        Builder withLogbrokerToolsResourceInfo(SandboxResourceInfo logbrokerToolsResourceInfo) {
            this.logbrokerToolsResourceInfo = Optional.ofNullable(logbrokerToolsResourceInfo);
            return this;
        }

        public Builder withEndpointSets(Map<String, TEndpointSetSpec> endpointSets) {
            this.endpointSets = endpointSets;
            return this;
        }

        Builder withDruLayerResourceInfo(SandboxResourceInfo druLayerResourceInfo) {
            this.druLayerResourceInfo = Optional.ofNullable(druLayerResourceInfo);
            return this;
        }

        public Builder withCoredumpToolResourceInfo(SandboxResourceInfo coredumpToolResourceInfo) {
            this.coredumpToolResourceInfo = Optional.ofNullable(coredumpToolResourceInfo);
            return this;
        }

        public Builder withGdbLayerResourceInfo(SandboxResourceInfo gdbLayerResourceInfo) {
            this.gdbLayerResourceInfo = Optional.ofNullable(gdbLayerResourceInfo);
            return this;
        }

        private Builder withDeploySettings(Optional<DeploySettings> deploySettings) {
            this.deploySettings = deploySettings;
            return this;
        }

        Builder withDeploySettings(DeploySettings deploySettings) {
            return withDeploySettings(Optional.ofNullable(deploySettings));
        }

        Builder withoutDeploySettings() {
            return withDeploySettings(Optional.empty());
        }

        public Builder withDetails(DeployUnitSpecDetails details) {
            this.details = details;
            return this;
        }

        Builder withPatchersRevision(int patchersRevision) {
            this.patchersRevision = patchersRevision;
            return this;
        }

        public Builder withSoxService(boolean soxService) {
            this.soxService = soxService;
            return this;
        }

        Builder withPortoWorkloadMetrics(boolean collectPortoMetricsFromSidecars) {
            this.collectPortometricsFromSidecars = collectPortoMetricsFromSidecars;
            return this;
        }

        public Builder withPodAgentResourceInfo(SandboxResourceInfo podAgentResourceInfo) {
            return withPodAgentResourceInfo(Optional.ofNullable(podAgentResourceInfo));
        }

        public Builder withPodAgentResourceInfo(Optional<SandboxResourceInfo> podAgentResourceInfo) {
            this.podAgentResourceInfo = podAgentResourceInfo;
            return this;
        }

        public Builder withLogrotateConfig(Map<String, LogrotateConfig> logrotateConfig) {
            this.logrotateConfig = logrotateConfig;
            return this;
        }
    }
}
