package ru.yandex.infra.stage.dto;

import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;

import ru.yandex.infra.stage.yp.Retainment;
import ru.yandex.yp.client.api.DataModel.TPodSpec;
import ru.yandex.yp.client.api.TReplicaSetScaleSpec;
import ru.yandex.yp.client.api.TReplicaSetStatus;
import ru.yandex.yp.model.YpObjectType;
import ru.yandex.yt.ytree.TAttributeDictionary;

public abstract class DeployUnitSpecDetails {
    public abstract Set<String> extractClusters();
    public abstract TPodSpec getPodSpec();
    public abstract TAttributeDictionary getLabels();
    public abstract DeployUnitStatusDetails createStatusDetails(String deployPrimitiveId, List<String> endpointSetIds, Map<String, Optional<TReplicaSetStatus>> statuses);
    public abstract Retainment shouldRetain(ClusterAndType clusterAndType);
    public abstract void validateDeploymentStrategy(List<String> errors);
    public abstract String objectDescription();
    public abstract boolean supportsAutoScaling();
    public abstract Optional<TReplicaSetScaleSpec> getAutoscale(String cluster);
    public abstract PodAgentConfig extractPodAgentConfig();

    protected Retainment retainByCluster(ClusterAndType clusterAndType) {
        String cluster = clusterAndType.getCluster().get();
        if (extractClusters().contains(cluster)) {
            return new Retainment(true, String.format("%s has pods in cluster '%s'", objectDescription(), cluster));
        } else {
            return new Retainment(false, String.format("%s does not have pods in cluster '%s'", objectDescription(), cluster));
        }
    }

    protected Retainment retainUnknownType(YpObjectType type) {
        return new Retainment(true, String.format("%s does not know about object of type '%s', retain for safety",
                objectDescription(), type));
    }
}
