package ru.yandex.infra.stage.dto;

import java.util.Objects;
import java.util.Optional;

import com.google.common.base.MoreObjects;

public class DeploymentStrategy {
    private final int maxUnavailable;

    // Minimum number of seconds after pod creation to be considered available.
    private final int minCreatedSeconds;
    // Max allowed hardware maintenance duration in seconds during which pods may be unavailable
    private final int maxTolerableDowntimeSeconds;
    // max_unavailable analogue, but only for eviction/maintenance-related unavailability
    private final int maxTolerableDowntimePods;
    // Describes how many pods to update at a time and min delay between updates.
    private final Optional<DeploySpeed> deploySpeed;

    public DeploymentStrategy(int maxUnavailable,
                                 int minCreatedSeconds,
                                 int maxTolerableDowntimeSeconds,
                                 int maxTolerableDowntimePods,
                                 Optional<DeploySpeed> deploySpeed) {
        this.maxUnavailable = maxUnavailable;
        this.minCreatedSeconds = minCreatedSeconds;
        this.maxTolerableDowntimeSeconds = maxTolerableDowntimeSeconds;
        this.maxTolerableDowntimePods = maxTolerableDowntimePods;
        this.deploySpeed = deploySpeed;
    }

    public int getMaxUnavailable() { return maxUnavailable; }

    public int getMinCreatedSeconds() { return minCreatedSeconds; }

    public int getMaxTolerableDowntimeSeconds() { return maxTolerableDowntimeSeconds; }

    public int getMaxTolerableDowntimePods() { return maxTolerableDowntimePods; }

    public Optional<DeploySpeed> getDeploySpeed() { return deploySpeed; }

    @Override
    public boolean equals(Object o) {
        if (this == o) return true;
        if (!(o instanceof DeploymentStrategy)) return false;
        DeploymentStrategy that = (DeploymentStrategy) o;
        return maxUnavailable == that.maxUnavailable &&
                minCreatedSeconds == that.minCreatedSeconds &&
                maxTolerableDowntimeSeconds == that.maxTolerableDowntimeSeconds &&
                maxTolerableDowntimePods == that.maxTolerableDowntimePods &&
                Objects.equals(deploySpeed, that.deploySpeed);
    }

    @Override
    public int hashCode() {
        return Objects.hash(maxUnavailable,
                            minCreatedSeconds,
                            maxTolerableDowntimeSeconds,
                            maxTolerableDowntimePods,
                            deploySpeed);
    }

    @Override
    public String toString() {
        return MoreObjects.toStringHelper(this)
                .add("maxUnavailable", maxUnavailable)
                .add("minCreatedSeconds", minCreatedSeconds)
                .add("maxTolerableDowntimeSeconds", maxTolerableDowntimeSeconds)
                .add("maxTolerableDowntimePods", maxTolerableDowntimePods)
                .add("deploySpeed", deploySpeed)
                .toString();
    }
}
