package ru.yandex.infra.stage.dto;

import java.util.Objects;

import com.google.common.base.MoreObjects;

public class DockerImageDescription {
    private final String registryHost;
    private final String name;
    private final String tag;

    public DockerImageDescription(String registryHost, String name, String tag) {
        this.registryHost = registryHost;
        this.name = name;
        this.tag = tag;
    }

    public String getRegistryHost() {
        return registryHost;
    }

    public String getName() {
        return name;
    }

    public String getTag() { return tag; }

    @Override
    public String toString() {
        return MoreObjects.toStringHelper(this)
                .add("registryHost", registryHost)
                .add("name", name)
                .add("tag", tag)
                .toString();
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        DockerImageDescription that = (DockerImageDescription) o;
        return Objects.equals(registryHost, that.registryHost) &&
                Objects.equals(name, that.name) &&
                Objects.equals(tag, that.tag);
    }

    @Override
    public int hashCode() {
        return Objects.hash(registryHost, name, tag);
    }
}
