package ru.yandex.infra.stage.dto;

import java.util.Objects;

import com.google.common.base.MoreObjects;

public class DownloadableResource {
    private final String url;
    private final Checksum checksum;

    public DownloadableResource(String url, Checksum checksum) {
        this.url = url;
        this.checksum = checksum;
    }

    public String getUrl() {
        return url;
    }

    public Checksum getChecksum() {
        return checksum;
    }

    @Override
    public String toString() {
        return MoreObjects.toStringHelper(this)
                .add("url", url)
                .add("checksum", checksum)
                .toString();
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        DownloadableResource that = (DownloadableResource) o;
        return Objects.equals(url, that.url) &&
                Objects.equals(checksum, that.checksum);
    }

    @Override
    public int hashCode() {
        return Objects.hash(url, checksum);
    }
}
