package ru.yandex.infra.stage.dto;

import java.util.Objects;

import com.google.common.base.MoreObjects;

import ru.yandex.infra.controller.dto.Acl;
import ru.yandex.infra.controller.dto.SchemaMeta;
import ru.yandex.yp.client.api.Autogen;

public class DynamicResourceMeta extends SchemaMeta {
    private final String podSetId;

    public DynamicResourceMeta(String id, Acl acl, String fqid, String uuid, long creationTime,  String podSetId) {
        super(id, acl, fqid, uuid, creationTime);
        this.podSetId = podSetId;
    }

    public static DynamicResourceMeta fromProto(Autogen.TDynamicResourceMeta proto) {
        return new DynamicResourceMeta(proto.getId(),
                new Acl(proto.getAclList()),
                proto.getFqid(),
                proto.getUuid(),
                proto.getCreationTime(),
                proto.getPodSetId());
    }

    public String getPodSetId() {
        return podSetId;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        DynamicResourceMeta that = (DynamicResourceMeta) o;
        return super.equals(o) &&
                Objects.equals(podSetId, that.podSetId);
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), podSetId);
    }

    @Override
    public String toString() {
        return addFields(MoreObjects.toStringHelper(this))
                .add("podSetId", podSetId)
                .toString();
    }
}
