package ru.yandex.infra.stage.dto;

import java.util.Objects;

import com.google.common.base.MoreObjects;

import ru.yandex.yp.client.api.DynamicResource.TDynamicResourceSpec;

public class DynamicResourceSpec {
    private final String deployUnitRef;
    private final TDynamicResourceSpec dynamicResource;

    public DynamicResourceSpec(String deployUnitRef,
                               TDynamicResourceSpec dynamicResource) {
        this.deployUnitRef = deployUnitRef;
        this.dynamicResource = dynamicResource;
    }

    public String getDeployUnitRef() {
        return deployUnitRef;
    }

    public TDynamicResourceSpec getDynamicResource() {
        return dynamicResource;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        DynamicResourceSpec that = (DynamicResourceSpec) o;
        return Objects.equals(deployUnitRef, that.deployUnitRef) &&
                Objects.equals(dynamicResource, that.dynamicResource);
    }

    @Override
    public int hashCode() {
        return Objects.hash(deployUnitRef, dynamicResource);
    }

    @Override
    public String toString() {
        return MoreObjects.toStringHelper(this)
                .add("deployUnitRef", deployUnitRef)
                .add("dynamicResource", dynamicResource)
                .toString();
    }
}
