package ru.yandex.infra.stage.dto;

import java.util.Objects;

import com.google.common.base.MoreObjects;


public class DynamicResourceStatus {

    private final DynamicResourceSpec currentTarget;

    private final DynamicResourceRevisionStatus status;

    public DynamicResourceStatus(DynamicResourceSpec currentTarget, DynamicResourceRevisionStatus status) {
        this.currentTarget = currentTarget;
        this.status = status;
    }

    public DynamicResourceSpec getCurrentTarget() {
        return currentTarget;
    }

    public DynamicResourceRevisionStatus getStatus() {
        return status;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        DynamicResourceStatus that = (DynamicResourceStatus) o;
        return currentTarget.equals(that.currentTarget) &&
                status.equals(that.status);
    }

    @Override
    public int hashCode() {
        return Objects.hash(currentTarget, status);
    }

    @Override
    public String toString() {
        return MoreObjects.toStringHelper(this)
                .add("currentTarget", currentTarget)
                .add("status", status)
                .toString();
    }
}
