package ru.yandex.infra.stage.dto;

import java.util.Objects;

import com.google.common.base.MoreObjects;

import ru.yandex.infra.controller.dto.Acl;
import ru.yandex.infra.controller.dto.SchemaMeta;
import ru.yandex.yp.client.api.Autogen;

public class HorizontalPodAutoscalerMeta extends SchemaMeta {
    private final String replicaSetId;

    public HorizontalPodAutoscalerMeta(String id, Acl acl, String fqid, String uuid, long creationTime, String replicaSetId) {
        super(id, acl, fqid, uuid, creationTime);
        this.replicaSetId = replicaSetId;
    }

    public static HorizontalPodAutoscalerMeta fromProto(Autogen.THorizontalPodAutoscalerMeta proto) {
        return new HorizontalPodAutoscalerMeta(proto.getId(),
                new Acl(proto.getAclList()),
                proto.getFqid(),
                proto.getUuid(),
                proto.getCreationTime(),
                proto.getReplicaSetId());
    }

    public String getReplicaSetId() {
        return replicaSetId;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof HorizontalPodAutoscalerMeta)) {
            return false;
        }
        HorizontalPodAutoscalerMeta that = (HorizontalPodAutoscalerMeta) o;
        return super.equals(o) &&
                Objects.equals(replicaSetId, that.replicaSetId);
    }

    @Override
    public int hashCode() {
        return Objects.hash(replicaSetId, super.hashCode());
    }

    @Override
    public String toString() {
        return addFields(MoreObjects.toStringHelper(this))
                .add("replicaSetId", replicaSetId)
                .toString();
    }

}
