package ru.yandex.infra.stage.dto;

import com.google.common.base.Objects;

public class InfraComponents {
    private final boolean allowAutomaticUpdate;

    public InfraComponents(boolean allowAutomaticUpdate) {
        this.allowAutomaticUpdate = allowAutomaticUpdate;
    }

    public boolean isAllowAutomaticUpdate() {
        return allowAutomaticUpdate;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        InfraComponents that = (InfraComponents) o;
        return allowAutomaticUpdate == that.allowAutomaticUpdate;
    }

    @Override
    public String toString() {
        return "InfraComponents{" +
                "allowAutomaticUpdate=" + allowAutomaticUpdate +
                '}';
    }

    @Override
    public int hashCode() {
        return Objects.hashCode(allowAutomaticUpdate);
    }
}
