package ru.yandex.infra.stage.dto;

import com.google.common.base.MoreObjects;
import com.google.common.base.Objects;

public class LogbrokerCustomTopicRequest implements LogbrokerTopicRequest {

    private final LogbrokerTopicDescription topicDescription;
    private final SecretSelector secretSelector;

    public LogbrokerCustomTopicRequest(LogbrokerTopicDescription topicDescription, SecretSelector secretSelector) {
        this.topicDescription = topicDescription;
        this.secretSelector = secretSelector;
    }

    public LogbrokerTopicDescription getTopicDescription() {
        return topicDescription;
    }

    public SecretSelector getSecretSelector() {
        return secretSelector;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        LogbrokerCustomTopicRequest that = (LogbrokerCustomTopicRequest) o;
        return Objects.equal(topicDescription, that.topicDescription) && Objects.equal(secretSelector,
                that.secretSelector);
    }

    @Override
    public int hashCode() {
        return Objects.hashCode(topicDescription, secretSelector);
    }

    @Override
    public String toString() {
        return MoreObjects.toStringHelper(this)
                .add("topicDescription", topicDescription)
                .add("secretSelector", secretSelector)
                .toString();
    }

    public LogbrokerCustomTopicRequest withTvmClientId(long tvmClientId) {
        return new LogbrokerCustomTopicRequest(
            new LogbrokerTopicDescription(tvmClientId, topicDescription.getName()),
            secretSelector
        );
    }

    public LogbrokerCustomTopicRequest withTopicName(String topicName) {
        return new LogbrokerCustomTopicRequest(
                new LogbrokerTopicDescription(topicDescription.getTvmClientId(), topicName),
                secretSelector
        );
    }

    public LogbrokerCustomTopicRequest withSecretAlias(String secretAlias) {
        return new LogbrokerCustomTopicRequest(
                topicDescription,
                new SecretSelector(secretAlias, secretSelector.getKey())
        );
    }

    public LogbrokerCustomTopicRequest withSecretKey(String secretKey) {
        return new LogbrokerCustomTopicRequest(
                topicDescription,
                new SecretSelector(secretSelector.getAlias(), secretKey)
        );
    }

}

