package ru.yandex.infra.stage.dto;

import java.util.Objects;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.google.common.base.MoreObjects;

public class LogbrokerDelegationTokenRequest
{
    private final static String COMMENT_KEY = "comment";
    private final static String COMMENT_VALUE = "created by stage controller";
    private final static String SIGNATURE_KEY = "signature";
    private final static String TVM_CLIENT_ID_KEY = "tvm_client_id";

    private final Long ypTvmClientId;
    private final String signature;

    public LogbrokerDelegationTokenRequest(String signature, Long ypTvmClientId) {
        this.ypTvmClientId = ypTvmClientId;
        this.signature = signature;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        LogbrokerDelegationTokenRequest that = (LogbrokerDelegationTokenRequest) o;
        return Objects.equals(ypTvmClientId, that.ypTvmClientId) &&
                Objects.equals(signature, that.signature);
    }

    @Override
    public int hashCode() {
        return Objects.hash(ypTvmClientId, signature);
    }

    @Override
    public String toString() {
        return MoreObjects.toStringHelper(this)
                .add("ypTvmClientId", ypTvmClientId)
                .add("signature", signature)
                .toString();
    }

    public String toJsonString() {
        ObjectMapper mapper = new ObjectMapper();
        ObjectNode confNode = mapper.createObjectNode();
        confNode.put(TVM_CLIENT_ID_KEY, String.valueOf(ypTvmClientId));
        confNode.put(SIGNATURE_KEY, signature);
        confNode.put(COMMENT_KEY, COMMENT_VALUE);
        try {
            return mapper.writeValueAsString(confNode);
        } catch (JsonProcessingException e) {
            throw new RuntimeException(e);
        }
    }
}
