package ru.yandex.infra.stage.dto;

import java.util.Objects;
import java.util.OptionalInt;
import java.util.OptionalLong;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.MoreObjects;

import ru.yandex.infra.stage.podspecs.patcher.logbroker.LogbrokerPatcherUtils;

public class LogbrokerDestroyPolicy {

    private final int maxTries;
    private final long restartPeriodMs;

    @VisibleForTesting
    public LogbrokerDestroyPolicy() {
        this(OptionalInt.empty(), OptionalLong.empty());
    }

    public LogbrokerDestroyPolicy(OptionalInt maxTries, OptionalLong restartPeriodMs) {
        this.maxTries = maxTries.orElse(LogbrokerPatcherUtils.DEFAULT_UNIFIED_AGENT_POLICY_MAX_TRIES);
        this.restartPeriodMs = restartPeriodMs.orElse(LogbrokerPatcherUtils.DEFAULT_UNIFIED_AGENT_POLICY_RESTART_PERIOD_MS);
    }

    public int getMaxTries() {
        return maxTries;
    }

    public long getRestartPeriodMs() {
        return restartPeriodMs;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        LogbrokerDestroyPolicy that = (LogbrokerDestroyPolicy) o;
        return maxTries == that.maxTries &&
                restartPeriodMs == that.restartPeriodMs;
    }

    @Override
    public int hashCode() {
        return Objects.hash(maxTries, restartPeriodMs);
    }

    @Override
    public String toString() {
        return MoreObjects.toStringHelper(this)
                .add("maxTries", maxTries)
                .add("restartPeriodMs", restartPeriodMs)
                .toString();
    }

    @VisibleForTesting
    public LogbrokerDestroyPolicy withMaxTries(OptionalInt maxTries) {
        return new LogbrokerDestroyPolicy(maxTries, OptionalLong.of(restartPeriodMs));
    }

    @VisibleForTesting
    public LogbrokerDestroyPolicy withRestartPeriodMs(OptionalLong restartPeriodMs) {
        return new LogbrokerDestroyPolicy(OptionalInt.of(maxTries), restartPeriodMs);
    }
}
