package ru.yandex.infra.stage.dto;

import java.util.Optional;

import javax.annotation.Nonnull;

import com.google.common.base.MoreObjects;
import com.google.common.base.Objects;

public class LogbrokerTopicConfig {

    private final LogbrokerTopicDescription topicDescription;
    private final Optional<SecretSelector> customTopicSecretSelector;
    private final Optional<String> communalTopicTvmToken;

    public LogbrokerTopicConfig(LogbrokerTopicDescription topicDescription, @Nonnull SecretSelector customTopicSecretSelector) {
        this(topicDescription, customTopicSecretSelector, null);
    }

    public LogbrokerTopicConfig(LogbrokerTopicDescription topicDescription, @Nonnull String communalTopicTvmToken) {
        this(topicDescription, null, communalTopicTvmToken);
    }

    private LogbrokerTopicConfig(LogbrokerTopicDescription topicDescription,
                                 SecretSelector customTopicSecretSelector,
                                 String communalTopicTvmToken) {
        this.topicDescription = topicDescription;
        this.customTopicSecretSelector = Optional.ofNullable(customTopicSecretSelector);
        this.communalTopicTvmToken = Optional.ofNullable(communalTopicTvmToken);
    }

    public LogbrokerTopicDescription getTopicDescription() {
        return topicDescription;
    }

    public Optional<String> getCommunalTopicTvmToken() {
        return communalTopicTvmToken;
    }

    public Optional<SecretSelector> getCustomTopicSecretSelector() {
        return customTopicSecretSelector;
    }

    public boolean isCommunalTopic() {
        return communalTopicTvmToken.isPresent();
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        LogbrokerTopicConfig that = (LogbrokerTopicConfig) o;
        return Objects.equal(topicDescription, that.topicDescription)
                && Objects.equal(customTopicSecretSelector, that.customTopicSecretSelector)
                && Objects.equal(communalTopicTvmToken, that.communalTopicTvmToken);
    }

    @Override
    public int hashCode() {
        return Objects.hashCode(topicDescription, customTopicSecretSelector, communalTopicTvmToken);
    }

    @Override
    public String toString() {
        return MoreObjects.toStringHelper(this)
                .add("topicDescription", topicDescription)
                .add("customTopicSecretSelector", customTopicSecretSelector)
                .add("communalTopicTvmToken", isCommunalTopic() ? "(hidden)" : null)
                .toString();
    }

}
