package ru.yandex.infra.stage.dto;

import com.google.common.base.MoreObjects;
import com.google.common.base.Objects;

public class LogbrokerTopicDescription {

    private final long tvmClientId;
    private final String name;

    public LogbrokerTopicDescription(long tvmClientId, String name) {
        this.tvmClientId = tvmClientId;
        this.name = name;
    }

    public long getTvmClientId() {
        return tvmClientId;
    }

    public String getName() {
        return name;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        LogbrokerTopicDescription that = (LogbrokerTopicDescription) o;
        return tvmClientId == that.tvmClientId &&
                Objects.equal(name, that.name);
    }

    @Override
    public int hashCode() {
        return Objects.hashCode(tvmClientId, name);
    }

    @Override
    public String toString() {
        return MoreObjects.toStringHelper(this)
                .add("tvmId", tvmClientId)
                .add("name", name)
                .toString();
    }
}
