package ru.yandex.infra.stage.dto;

import java.util.Objects;

public class LogrotateConfig {

    private final String rawConfig;

    private final long runPeriodMillisecond;

    public LogrotateConfig(String rawConfig, long runPeriodMillisecond) {
        this.rawConfig = rawConfig;
        this.runPeriodMillisecond = runPeriodMillisecond;
    }

    public String getRawConfig() {
        return rawConfig;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        LogrotateConfig config = (LogrotateConfig) o;
        return runPeriodMillisecond == config.runPeriodMillisecond &&
                Objects.equals(rawConfig, config.rawConfig);
    }

    @Override
    public int hashCode() {
        return Objects.hash(rawConfig, runPeriodMillisecond);
    }

    public long getRunPeriodMillisecond() {
        return runPeriodMillisecond;
    }
}
