package ru.yandex.infra.stage.dto;

import java.util.List;
import java.util.Map;
import java.util.Objects;

import com.google.common.base.MoreObjects;

public class McrsUnitStatus extends DeployUnitStatusDetails {
    private final String replicaSetRef;
    private final Map<String, PerClusterStatus> clusterStatuses;

    public static class PerClusterStatus {
        private final List<String> endpointSetRefs;

        public PerClusterStatus(List<String> endpointSetRefs) {
            this.endpointSetRefs = endpointSetRefs;
        }

        public List<String> getEndpointSetRefs() {
            return endpointSetRefs;
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) return true;
            if (!(o instanceof PerClusterStatus)) return false;
            PerClusterStatus that = (PerClusterStatus) o;
            return Objects.equals(endpointSetRefs, that.endpointSetRefs);
        }

        @Override
        public int hashCode() {
            return Objects.hash(endpointSetRefs);
        }


        @Override
        public String toString() {
            return MoreObjects.toStringHelper(this)
                    .add("endpointSetRefs", endpointSetRefs)
                    .toString();
        }
    }

    public McrsUnitStatus(String replicaSetRef, Map<String, PerClusterStatus> clusterStatuses) {
        this.replicaSetRef = replicaSetRef;
        this.clusterStatuses = clusterStatuses;
    }

    public String getReplicaSetRef() {
        return replicaSetRef;
    }

    public Map<String, PerClusterStatus> getClusterStatuses() {
        return clusterStatuses;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) return true;
        if (!(o instanceof McrsUnitStatus)) return false;
        McrsUnitStatus that = (McrsUnitStatus) o;
        return Objects.equals(replicaSetRef, that.replicaSetRef) &&
                Objects.equals(clusterStatuses, that.clusterStatuses);
    }

    @Override
    public int hashCode() {
        return Objects.hash(replicaSetRef, clusterStatuses);
    }


    @Override
    public String toString() {
        return MoreObjects.toStringHelper(this)
                .add("replicaSetRef", replicaSetRef)
                .add("clusterStatuses", clusterStatuses)
                .toString();
    }
}
